function [q] = GlobalT(s,pb,f,rx,ry)

a = s(1)*pi/180;
b = s(2)*pi/180;
c = s(3)*pi/180;

tx = s(4);
ty = s(5);
tz = s(6);

pbH = [pb;1];

% 2.3 Extrinsic transformation

R = Euler2Mat(a,b,c);

T = [R, [tx;ty;tz]; 0,0,0,1];

pcH = T*pbH;

pc = pcH(1:3);

% 2.4 Intrinsic transformation

k = [f rx ry];

K = [f 0 rx/2; 0 f ry/2; 0 0 1];

% 2.5 Global transformation

P = K*[R, [tx;ty;tz]];

qH = P*pbH;
q = [qH(1)/qH(3); qH(2)/qH(3)];

