function [E,J] = LSE_sinus(s,x,y)

% Model: f = a1*sin(x+a2)
% State: s = [a1,a2];

% Error vector
E = y-s(1).*sin(x+s(2));

% Derivatives of f:
% df/da1 = sin(x+a2)
% df/da2 = a1*cos(x+a2)
J(:,1) = sin(x+s(2));
J(:,2) = s(1)*cos(x+s(2));
