% 2.1 Euler Angles representation

clear;
close all;

% Angles must be in radians!
a = 10*pi/180;
b = 20*pi/180;
c = 30*pi/180;

% Elementary rotation matrix around x
Rx = [1 0 0; 0 cos(a) -sin(a); 0 sin(a) cos(a)];

% Elementary rotation matrix around y
Ry = [cos(b) 0 -sin(b); 0 1 0; sin(b) 0 cos(b)];

% Elementary rotation matrix around z
Rz = [cos(c) -sin(c) 0; sin(c) cos(c) 0; 0 0 1];

% Rotation matrix
R = Rx*Ry*Rz

% Verify the orthogonality
I = R*R'

