% 3.1 Linear Regression (LSE)

clear;
close all;

% Data (columns vectors)
x = [1 2 3 4 5 6 7 8 9 10]';
y = [2.6892 3.3476 3.8128 5.1878 5.6323 6.5843 6.7507 7.2644 8.5423 9.0124]';

% Model: y = a1*x+a2
% State: s = [a1 a2];

% Construct the coefficient matrix (A)
% Ai = [xi 1]

l = length(x);
A = [x ones(l,1)];

% Solve for the minimum LSE error
s = inv(A'*A)*A'*y;

% Plot the results
% The estimated line is: y = s(1)*x+s(2)
yest = s(1)*x+s(2);

figure;
plot(x,yest);
hold;
plot(x,y,'b.');

% Modify one of the values, and do the optimization again
ymod = y;
ymod(5) = ymod(5)+5;

smod = inv(A'*A)*A'*ymod;
yest2 = smod(1)*x+smod(2);

figure;
plot(x,yest2);
hold;
plot(x,ymod,'b.');
