% 3.2 Weighted Linear Regression (LSE)

clear;
close all;

% Data (column vectors)
x = [1 2 3 4 5 6 7 8 9 10]';
y = [2.6892 3.3476 3.8128 5.1878 5.6323 6.5843 6.7507 7.2644 8.5423 9.0124]';

% Weights
w = [1 0.5 0.4 0.3 0.1 0.8 0.6 0.8 0.9 1]';
W = diag(w);

% Model: y = a1*x+a2
% State: s = [a1 a2];

% Construct the coefficient matrix (A)
% Ai = [xi 1]

l = length(x);
A = [x ones(l,1)];

% Solve for the minimum weighted-LSE error
s = inv(A'*W*A)*A'*W*y;

% Plot results
% The estimated line is: y = s(1)*x+s(2)
yest = s(1)*x+s(2);

figure;
plot(x,yest);
hold;
plot(x,y,'b.');

% Modify y5, and do the optimization again#
% LSE should be less sensitive to an outlier in y5
ymod = y;
ymod(5) = ymod(5)+5;

smod = inv(A'*W*A)*A'*W*ymod;
yest2 = smod(1)*x+smod(2);

figure;
plot(x,yest2);
hold;
plot(x,ymod,'b.');

% Modify y1, and do the optimization again
% LSE should be more sensitive to an outlier in y1
ymod = y;
ymod(1) = ymod(1)+5;

smod = inv(A'*W*A)*A'*W*ymod;
yest2 = smod(1)*x+smod(2);

figure;
plot(x,yest2);
hold;
plot(x,ymod,'b.');
