% World to screen projection: example

clear;
close all;

% The Body model consists of 4 points (a square) in space
pb1 = [-50; -50; 0];
pb2 = [50; -50; 0];
pb3 = [50; 50; 0];
pb4 = [-50; 50; 0];

f = 1000;
rx = 640;
ry = 480;

s = [10 20 30 50 30 500];

[q1] = GlobalT(s,pb1,f,rx,ry);
[q2] = GlobalT(s,pb2,f,rx,ry);
[q3] = GlobalT(s,pb3,f,rx,ry);
[q4] = GlobalT(s,pb4,f,rx,ry);

figure;
plot([q1(1) q2(1)], [q1(2) q2(2)]);
hold;
plot([q2(1) q3(1)], [q2(2) q3(2)]);
plot([q3(1) q4(1)], [q3(2) q4(2)]);
plot([q4(1) q1(1)], [q4(2) q1(2)]);
plot([q1(1), q2(1), q3(1), q4(1)], [q1(2), q2(2), q3(2), q4(2)], 'b.');
axis([0 640 0 480]);
