% 4.1 Motion models

clear;
close all;

% Brownian motion

dt = 0.1;

p = zeros(1000,1);
v = zeros(1000,1);

for t=2:1000
    w = randn(1,1);
    p(t) = p(t-1) + w*dt;
    v(t) = w;
end

figure;
plot(p,'b');
hold;
plot(v,'r');

sig = dt^2

% WNA motion

dt = 0.1;

p = zeros(1000,1);
v = zeros(1000,1);
a = zeros(1000,1);

for t=2:1000
    w = randn(1,1);
    
    p(t) = p(t-1) + v(t-1)*dt + 0.5*w*dt^2;
    v(t) = v(t-1) + w*dt;
    a(t) = w;
end

figure;
plot(p,'b');
hold;
plot(v,'r');
plot(a,'g');


A = [1 dt; 0 1]
B = [0.5*dt^2; dt]

C = B*B'

% Perturbed acceleration motion

dt = 0.1;

p = zeros(1000,1);
v = zeros(1000,1);
a = zeros(1000,1);
a0 = -9.81;

for t=2:1000
    w = randn(1,1);
    
    p(t) = p(t-1) + v(t-1)*dt + 0.5*(w+a0)*dt^2;
    v(t) = v(t-1) + (w+a0)*dt;
    a(t) = w+a0;
end

figure;
plot(p,'b');
hold;
plot(v,'r');
plot(a,'g');


A = [1 dt; 0 1]
B = [0.5*dt^2; dt]

C = B*B'
